//=============================================================================
// Luna Snippets
//=============================================================================
 /*:
 * @plugindesc v1.00 Tiny Snippets made for Luna sample game.
 * files on sub directory.
 * @author Visustella
 */

//=============================================================================
// Disable Font Outline
//=============================================================================
var _Window_Base_ResetFontSettings = Window_Base.prototype.resetFontSettings;
Window_Base.prototype.resetFontSettings = function() {
    _Window_Base_ResetFontSettings.call( this );
    this.contents.outlineWidth = 0;
};

//=============================================================================
// Add more global data for save files.
// By default, global data only has access to the following:
// info.globalId   = this._globalId;
// info.title      = $dataSystem.gameTitle;
// info.characters = $gameParty.charactersForSavefile();
// info.faces      = $gameParty.facesForSavefile();
// info.playtime   = $gameSystem.playtimeText();
// info.timestamp  = Date.now();
// so title, characters, faces and playtime
//=============================================================================
var _luna_makeSavefileInfo = DataManager.makeSavefileInfo;
DataManager.makeSavefileInfo = function() {
    var info = _luna_makeSavefileInfo.call(DataManager);
    info.gold = $gameParty.gold();
    info.mapName = $gameMap.displayName();
    return info;
};

//=============================================================================
// Enable EXP Rate
//=============================================================================
Game_Actor.prototype.expRate = function() {
    var rate = (this.currentExp() - this.currentLevelExp()) / (this.nextLevelExp() - this.currentLevelExp());
    if (this.level === this.maxLevel()) rate = 1;
        return rate;
};

//=============================================================================
// Shop Stat Comparator
//=============================================================================
Game_Actor.prototype.getCurrentSameTypeEquip = function(item) {
    var list = []
    var equips = this.equips()
    var slots = this.equipSlots()
    for (var i = 0; i < slots.length; i++) {
        if (slots[i] === item.etypeId) {
            list.push(equips[i])
        }
    }
    var paramId = DataManager.isWeapon(item) ? 2 : 3
    var worstParam = Number.MAX_VALUE
    var worstItem = null
    for (var j = 0; j < list.length; j++) {
        if (list[j] && list[j].params[paramId] < worstParam) {
            worstParam = list[j].params[paramId]
            worstItem = list[j]
        }
    }
    return worstItem || { params: [0,0,0,0,0,0,0,0] }
}

//=============================================================================
//  Grab Parameter from Name Input
//=============================================================================
var _Scene_Name_prepare = Scene_Name.prototype.prepare;
Scene_Name.prototype.prepare = function(actorId, maxLength) {
    _Scene_Name_prepare.call(this, actorId, maxLength);
    $gameVariables.setValue(10, this._actorId);
    console.log($gameVariables.value(10));
};

//=============================================================================
// Remove faceset from Window_Name
//=============================================================================
Window_NameEdit.prototype.left = function() {
    var nameCenter = this.contentsWidth() / 2;
    var nameWidth = (this._maxLength + 1) * this.charWidth();
    return Math.min(nameCenter - nameWidth / 2, this.contentsWidth() - nameWidth);
};

Window_NameEdit.prototype.refresh = function() {
    this.contents.clear();
    for (var i = 0; i < this._maxLength; i++) {
        this.drawUnderline(i);
    }
    for (var j = 0; j < this._name.length; j++) {
        this.drawChar(j);
    }
    var rect = this.itemRect(this._index);
    this.setCursorRect(rect.x, rect.y, rect.width, rect.height);
};

Window_NameEdit.prototype.faceWidth = function() {
    return 0;
};

//=============================================================================
// Fix Name Input Font Display
//=============================================================================
Window_NameEdit.prototype.drawChar = function(index) {
    var rect = this.itemRect(index);
    this.resetTextColor();
    this.drawText(this._name[index] || '', rect.x, rect.y, rect.width, 'center');
};

//=============================================================================
//  Disable Name Input Pages
//=============================================================================
Window_NameInput.LATIN1 =
  [ 'A','B','C','D','E',  'a','b','c','d','e',
    'F','G','H','I','J',  'f','g','h','i','j',
    'K','L','M','N','O',  'k','l','m','n','o',
    'P','Q','R','S','T',  'p','q','r','s','t',
    'U','V','W','X','Y',  'u','v','w','x','y',
    'Z','[',']','^','_',  'z','{','}','|','~',
    '0','1','2','3','4',  '!','#','$','%','&',
    '5','6','7','8','9',  '(',')','*','+','-',
    '/','=','@','<','>',  ':',';',' ','←','OK' ];

Window_NameInput.prototype.processOk = function() {
    if (this.character()) {
        this.onNameAdd();
    } else if (this.isPageChange()) {
        SoundManager.playCancel();
        this.processBack();
    } else if (this.isOk()) {
        this.onNameOk();
    }
};

Window_NameInput.prototype.cursorPagedown = function() {
    return false;
};

Window_NameInput.prototype.cursorPageup = function() {
    return false;
};

//=============================================================================
//  Disable Name Edit Window Display
//=============================================================================
Window_NameEdit.prototype.drawChar = function(index) {
    var rect = this.itemRect(index);
    this.resetTextColor();
    this.drawText(this._name[index] || '', rect.x, rect.y, rect.width, 'center');
};